

import Alkindi.Data.*;
import Alkindi.Services.*;
import Alkindi.Services.BeanIface.*;
import java.util.*;

public class loopRM
{
	static void usage() {
		System.out.println("gets products to rate for UID=0. Usage:");
		System.out.println("\tcall with 1 argument:");
		System.out.println("\t loops --	number of loops:");
	}
	
	static void main(String[] args) {
		long uid = 0;
		long loops = 0;

		if ( args.length > 0) {
			if (args[0].compareTo("-h") == 0 || args[0].compareTo("--help") == 0){
				usage();
				System.exit(1);
			}
			
			loops = Long.parseLong(args[0]);		   
		}
						

		try {
			IRatingManagerBean rmb = BeanUtil.getRatMgr();
			SystemUser nullSU = new SystemUser(uid);
			
			String outStr;
			int i;
			long elapsed;

			for (i=0;i<loops;i++){
           		Date prior = new Date();
				ProductList pl = rmb.getProductsToRate(nullSU, 8);
		   		if (pl == null) {
					System.out.println("no productList returned.");
					return;
				}
				outStr="Got 8 products, loop " + i + " out of " + loops + ":  ";
				for (int idx = 0; idx < pl.size(); idx ++) {
					Product pr = pl.get(idx);
					outStr = outStr + " p"+ idx + ":" + pr.id + "  ";
				}
				Date post = new Date();
				elapsed = post.getTime() - prior.getTime();
				System.out.println(outStr + " elapsed: " + elapsed + " ms");
			}
			rmb.remove();
		}
		catch( Exception e) {
			System.out.println(e.toString());
			e.printStackTrace();
		}

	}





}

